/*
 * Decompiled with CFR 0.152.
 */
package PSG_Emu;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class Speaker
implements Runnable {
    private byte[] i_buffer_sample = new byte[65536];
    private int i_buffer_sample_size;
    private int i_buffer_sample_pointer;
    private AudioFormat af_sample;
    private DataLine.Info dl_info;
    private SourceDataLine sdl_line;
    private byte current_state = 0;
    private final byte S_NOTSET = 0;
    private final byte S_READY = 1;
    private final byte S_LOADING = (byte)2;
    private final byte S_PLAYING = (byte)4;
    private final byte S_STOPING = (byte)8;
    private final byte S_STOPED = (byte)16;
    private final byte S_CLOSING = (byte)32;
    private final byte S_CLOSED = (byte)64;

    public void set_framerate(float f) {
        if (this.current_state != 0) {
            this.stop_playing();
            this.close_dataline();
        }
        this.af_sample = new AudioFormat(f, 8, 1, true, false);
        this.open_dataline();
    }

    public void clean_stream() {
        if (this.current_state == 0) {
            return;
        }
        if (this.current_state == 4) {
            this.current_state = (byte)8;
            while (this.current_state == 8) {
            }
            this.current_state = (byte)2;
        }
        this.i_buffer_sample_size = 0;
    }

    public void add_data(byte by) {
        if (this.current_state == 0) {
            return;
        }
        if (this.current_state == 4) {
            this.current_state = (byte)8;
            while (this.current_state == 8) {
            }
            this.current_state = (byte)2;
        }
        if (this.i_buffer_sample_size + 1 == this.i_buffer_sample.length) {
            byte[] byArray = new byte[this.i_buffer_sample.length + 65536];
            System.arraycopy(this.i_buffer_sample, 0, byArray, 0, this.i_buffer_sample.length);
            this.i_buffer_sample = byArray;
        }
        this.i_buffer_sample[this.i_buffer_sample_size++] = by;
    }

    public void stop_playing() {
        if (this.current_state == 0) {
            return;
        }
        this.current_state = (byte)8;
        while (this.current_state == 8) {
        }
        System.gc();
    }

    public void start_playing() {
        if (this.current_state == 0) {
            return;
        }
        if (this.current_state == 4) {
            this.stop_playing();
        }
        this.current_state = (byte)4;
        this.i_buffer_sample_pointer = 0;
        this.sdl_line.start();
    }

    public void open_dataline() {
        try {
            this.dl_info = new DataLine.Info(SourceDataLine.class, this.af_sample);
            if (!AudioSystem.isLineSupported(this.dl_info)) {
                this.current_state = 0;
                return;
            }
            this.sdl_line = (SourceDataLine)AudioSystem.getLine(this.dl_info);
            this.sdl_line.open(this.af_sample);
            this.current_state = 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close_dataline() {
        try {
            this.sdl_line.stop();
            this.sdl_line.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.current_state = (byte)64;
    }

    public void kill() {
        if (this.current_state == 0) {
            return;
        }
        if (this.current_state == 4) {
            this.stop_playing();
        }
        this.current_state = (byte)32;
    }

    public void run() {
        while (this.current_state != 32) {
            try {
                Thread.currentThread();
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (this.current_state == 4) {
                int n = this.i_buffer_sample_size - this.i_buffer_sample_pointer;
                int n2 = this.sdl_line.available();
                if (n < n2) {
                    n2 = n;
                }
                try {
                    this.sdl_line.write(this.i_buffer_sample, this.i_buffer_sample_pointer, n2);
                    try {
                        Thread.currentThread();
                        Thread.sleep(2L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.i_buffer_sample_pointer += n2;
                    if (this.i_buffer_sample_size != this.i_buffer_sample_pointer) continue;
                    this.sdl_line.drain();
                    this.current_state = (byte)8;
                }
                catch (Exception exception) {}
            }
            if (this.current_state != 8) continue;
            try {
                this.sdl_line.flush();
                this.sdl_line.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.current_state = 1;
        }
        this.close_dataline();
    }
}

